import 'package:flutter/material.dart';
import 'package:slpl_app/footballnews.dart';

class Newsdetails extends StatelessWidget {
  const Newsdetails({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Demo',
      theme: ThemeData(
        // colorScheme: ColorScheme.fromSwatch(primarySwatch: Colors.blue),
        useMaterial3: true,
      ),
      home: FootballNewsDetailsScreen(
        title: 'SPORTS MINISTER WITNESSES ANNUAL SQUASH GRAND FINAL',
        description:
            'Minister of Sports Madam Augusta James-Teima last Saturday witnessed the Squash Association Annual Tournament Grand Final held at the Squash Complex, YSC'
            'In her opening statement, the Minister expressed thanks to the President and executive members for the invitation. "I am happy to be here, and I love the game of Squash. I am also satisfied with the reports concerning developments in the Association, including national and international competitions. Special thanks to the President and team for a job well done." '
            'She added: "Watching the tournament this evening, I am impressed with the performance of the players; both female and male.',
      ),
    );
  }
}

class FootballNewsDetailsScreen extends StatelessWidget {
  final String title;
  final String description;

  FootballNewsDetailsScreen({required this.title, required this.description});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromARGB(255, 16, 99, 60),
        foregroundColor: const Color.fromARGB(255, 252, 252, 252),
        leading: IconButton(
          icon: Icon(Icons.arrow_back),
          onPressed: () {
            // Navigate back when the back button is pressed
            Navigator.push(
              context,
              MaterialPageRoute(builder: (context) => const News()),
            );
          },
        ),
        title: Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(8),
          ),
          child: const Text(
            "News Details",
            style: TextStyle(
              color: Color.fromARGB(255, 246, 247, 248),
              fontSize: 20,
              fontWeight: FontWeight.bold,
            ),
          ),
        ),
      ),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              title,
              style: const TextStyle(
                fontSize: 15,
                fontWeight: FontWeight.bold,
              ),
            ),
            SizedBox(height: 14),
            Text(
              description,
              style: TextStyle(
                fontSize: 16,
              ),
            ),
          ],
        ),
      ),
    );
  }
}

void main() {
  runApp(Newsdetails());
}
