import 'package:flutter/material.dart';
import 'package:slpl_app/main.dart';

void main() {
  runApp(MyApp());
}

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Football App',
      theme: ThemeData(
        primarySwatch: Colors.blue,
      ),
      home: WelcomeScreen(),
    );
  }
}

class WelcomeScreen extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        actions: const [
          Padding(
            padding: EdgeInsets.only(right: 16.0),
            child: Text(
              "Skip",
              style: TextStyle(
                color: Color.fromARGB(255, 9, 35, 56),
                fontSize: 16,
                fontWeight: FontWeight.bold,
              ),
            ),
          ),
        ],
      ),
      body: ListView(
        children: [
          GestureDetector(
            onHorizontalDragEnd: (details) {
              if (details.primaryVelocity! < 0) {
                // Swiped from right to left (forward)
                print('Swiped left!');
                Navigator.push(
                  context,
                  MaterialPageRoute(builder: (context) => IntroScreen()),
                );
              }
            },
            child: Container(
              alignment: Alignment.center,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Image.asset(
                    'assets/slplmale.jpg',
                    width: 350,
                  ),
                  SizedBox(height: 120),
                  const Text(
                    'Sierra Leone Male Premier league',
                    style: TextStyle(
                        fontSize: 20,
                        color: Color.fromARGB(255, 61, 61, 66),
                        fontWeight: FontWeight.bold),
                  ),
                  const SizedBox(
                    height: 5,
                  ),
                  Container(
                    width: 400,
                    padding: const EdgeInsets.all(5),
                    child: const Center(
                      child: Text(
                        'Sierra Leone National Premier League is a professional football league in Sierra Leone. It was founded in 1967.',
                        textAlign: TextAlign.center,
                        style: TextStyle(
                          fontSize: 15,
                          color: Color.fromARGB(255, 136, 133, 133),
                          fontWeight: FontWeight.bold,
                        ),
                      ),
                    ),
                  ),
                  const SizedBox(height: 1),
                  ElevatedButton(
                    onPressed: () {
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => IntroScreen()),
                      );
                    },
                    style: ElevatedButton.styleFrom(
                      backgroundColor: const Color.fromARGB(255, 9, 35, 56),
                    ),
                    child: const Icon(
                      Icons.arrow_forward,
                      color: Colors.white,
                    ),
                  )
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}

class IntroScreen extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        actions: const [
          Padding(
            padding:
                EdgeInsets.only(right: 16.0), // Adjust the padding as needed
            child: Text(
              "Skip",
              style: TextStyle(
                color: Color.fromARGB(255, 9, 35, 56),
                fontSize: 16,
                fontWeight: FontWeight.bold,
              ),
            ),
          ),
        ],
      ),
      body: Container(
        alignment: Alignment.center,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Image.asset(
              'assets/femaleslpl.jpg',
              width: 350,
            ),
            SizedBox(height: 135),
            const Text(
              'Sierra Leone Female Premier league',
              style: TextStyle(
                  fontSize: 20,
                  color: Color.fromARGB(255, 61, 61, 66),
                  fontWeight: FontWeight.bold),
            ),
            const SizedBox(
              height: 10,
            ),
            Container(
                width: 350, // Set the width of the container
                padding:
                    EdgeInsets.all(5), // Optional: Add padding around the text
                // Optional: Set background color of the container
                child: const Center(
                  child: Text(
                    'On October 20, 2022, the Womens Premier League returned to Sierra Leone. The 12-team league is making a comeback after a 32-year absence. It was first launched in the early 1990s',
                    textAlign: TextAlign.center, // Set text alignment to center
                    style: TextStyle(
                      fontSize: 15,
                      color: Color.fromARGB(255, 136, 133, 133),
                      fontWeight: FontWeight.bold,
                    ),
                  ),
                )),
            const SizedBox(height: 10),
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                ElevatedButton(
                  onPressed: () {
                    Navigator.pop(context);
                  },
                  style: ElevatedButton.styleFrom(
                    backgroundColor: const Color.fromARGB(
                        255, 9, 35, 56), // Set background color of the button
                  ),
                  child: const Icon(
                    Icons.arrow_back,
                    color: Colors.white,
                  ),
                ),
                SizedBox(width: 20),
                ElevatedButton(
                  onPressed: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(builder: (context) => const SlplApp()),
                    );
                  },
                  style: ElevatedButton.styleFrom(
                    backgroundColor: const Color.fromARGB(
                        255, 9, 35, 56), // Set background color of the button
                  ),
                  child: const Icon(
                    Icons.arrow_forward,
                    color: Colors.white,
                  ),
                ),
              ],
            ),
          ],
        ),
      ),
    );
  }
}

class MainScreen extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text('Football App'),
      ),
      body: const Center(
        child: Text('Football league name and trophy'),
      ),
    );
  }
}
