import 'package:flutter/material.dart';
import 'malefootballfixtures.dart';
import 'footballnews.dart';
import 'mainscreen.dart';

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Demo',
      theme: ThemeData(
        // colorScheme: ColorScheme.fromSwatch(primarySwatch: Colors.blue),
        useMaterial3: true,
      ),
      home: WelcomeScreen(),
    );
  }
}

class SlplApp extends StatefulWidget {
  const SlplApp({Key? key}) : super(key: key);

  @override
  State<SlplApp> createState() => _SlplAppState();
}

class _SlplAppState extends State<SlplApp> {
  // final GlobalKey<FormState> _formKey = GlobalKey();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        body: Container(
            alignment: Alignment.center,
            child:
                Column(mainAxisAlignment: MainAxisAlignment.center, children: [
              Image.asset(
                'assets/slpllogo.png',
                width: 200,
              ),
              SizedBox(height: 80),
              const Text(
                'Sierra Leone Premier league',
                style: TextStyle(
                    fontSize: 20,
                    color: Color.fromARGB(255, 61, 61, 66),
                    fontWeight: FontWeight.bold),
              ),
              const SizedBox(
                height: 5,
              ),
              Container(
                  width: 400, // Set the width of the container
                  padding: const EdgeInsets.all(
                      5), // Optional: Add padding around the text
                  // Optional: Set background color of the container
                  child: const Center(
                    child: Text(
                      'Sierra Leone National Premier League is a professional football league in Sierra Leone. It was founded in 1967.',
                      textAlign:
                          TextAlign.center, // Set text alignment to center
                      style: TextStyle(
                        fontSize: 16,
                        color: Color.fromARGB(255, 136, 133, 133),
                        fontWeight: FontWeight.bold,
                      ),
                    ),
                  ))
            ])),
        floatingActionButtonLocation: FloatingActionButtonLocation.centerDocked,
        floatingActionButton: FloatingActionButton(
          onPressed: () {
            // Add onPressed functionality here
          },
          child: const Icon(Icons.add),
          backgroundColor: Color.fromARGB(255, 9, 35, 56),
          foregroundColor: Colors.white,
          elevation: 4.0,
        ),
        bottomNavigationBar: BottomAppBar(
          color: Color.fromARGB(255, 141, 171, 157),
          shape: const CircularNotchedRectangle(),
          child: Container(
            height: 60.0,
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceAround,
              children: <Widget>[
                PopupMenuButton<String>(
                  itemBuilder: (context) => [
                    const PopupMenuItem(
                      value: 'Home',
                      child: Row(
                        children: [
                          Icon(Icons.home),
                          SizedBox(width: 5),
                          Text('Home'),
                        ],
                      ),
                    ),
                    const PopupMenuItem(
                      value: 'Account',
                      child: Row(
                        children: [
                          Icon(Icons.account_circle),
                          SizedBox(width: 5),
                          Text('Account'),
                        ],
                      ),
                    ),
                  ],
                  onSelected: (value) {
                    // Handle menu item selection here
                  },
                ),
                SizedBox(width: 40.0), // Adjust the width as needed
                PopupMenuButton<String>(
                  itemBuilder: (context) => [
                    const PopupMenuItem(
                      value: 'FemaleFootball',
                      child: Row(
                        children: [
                          Icon(Icons.sports_soccer),
                          SizedBox(width: 5),
                          Text('Female Football'),
                        ],
                      ),
                    ),
                    const PopupMenuItem(
                      value: 'malefootball',
                      child: Row(
                        children: [
                          Icon(Icons.sports_soccer),
                          SizedBox(width: 5),
                          Text('Male Football'),
                        ],
                      ),
                    ),
                    const PopupMenuItem(
                      value: 'sportnews',
                      child: Row(
                        children: [
                          Icon(Icons.newspaper),
                          SizedBox(width: 5),
                          Text('Football News'),
                        ],
                      ),
                    ),
                  ],
                  onSelected: (value) {
                    // Handle menu item selection here
                    if (value == 'FemaleFootball') {
                      // Handle FemaleFootball menu item selection
                    } else if (value == 'malefootball') {
                      Navigator.push(
                        context,
                        MaterialPageRoute(
                            builder: (context) => FixtureScreen()),
                      );
                    } else if (value == 'sportnews') {
                      // Handle sportnews menu item selection FootballNewsScreen
                      Navigator.push(
                        context,
                        MaterialPageRoute(builder: (context) => News()),
                      );
                    }
                  },
                ),
              ],
            ),
          ),
        ));
  }
}

void main() {
  runApp(const MyApp());
}
