import 'package:flutter/material.dart';
import 'package:file_picker/file_picker.dart';
import 'package:http/http.dart' as http;

import 'config.dart';

class ImportFixtures extends StatelessWidget {
  const ImportFixtures({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromARGB(255, 16, 99, 60),
        title: const Text(
          'Import Fixtures',
          style: TextStyle(color: Colors.white),
        ),
        iconTheme: const IconThemeData(
            color: Colors.white), // Set the color of the back arrow icon
      ),
      body: Center(
          child: ElevatedButton(
        onPressed: () {
          pickAndUploadExcel(context);
        },
        style: ElevatedButton.styleFrom(
          primary:
              Color.fromARGB(255, 16, 99, 60), // Set the background color here
        ),
        child: const Text(
          'Upload Excel',
          style: TextStyle(
              color: Colors.white,
              fontWeight: FontWeight.bold), // Set the text color
        ),
      )),
    );
  }

  Future<void> pickAndUploadExcel(BuildContext context) async {
    FilePickerResult? result = await FilePicker.platform.pickFiles(
      allowedExtensions: ['xlsx'],
      type: FileType.custom,
    );

    if (result != null) {
      String filePath = result.files.single.path!;

      Uri uri = Uri.parse('${AppConfig.baseUrl}import_fixtures.php');
      var request = http.MultipartRequest('POST', uri)
        ..files.add(await http.MultipartFile.fromPath('excel', filePath));

      try {
        var streamedResponse = await request.send();
        var response = await http.Response.fromStream(streamedResponse);

        if (response.statusCode == 200) {
          showAlertDialog(context);
          print('File uploaded successfully');
        } else {
          print('Error: ${response.body}');
        }
      } catch (e) {
        print('Error: $e');
      }
    }
  }

  void showAlertDialog(BuildContext context) {
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return AlertDialog(
          title: const Text(
            'Fixtures Upload',
            style: TextStyle(fontSize: 17, fontWeight: FontWeight.bold),
          ),
          content: const Text(
            "Fixtures Uploaded Successfully",
            style: TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
          ),
          actions: <Widget>[
            TextButton(
              onPressed: () {
                Navigator.of(context).pop();
              },
              child: const Text(
                'OK',
                style: TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
              ),
            ),
          ],
        );
      },
    );
  }
}
