import 'dart:io';
import 'config.dart';
import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;
import 'dart:convert';
import 'dart:async';
import 'package:image_picker/image_picker.dart';
//import 'package:shared_preferences/shared_preferences.dart';

class ViewTeams extends StatefulWidget {
  const ViewTeams({super.key});

  @override
  _ViewTeamsState createState() => _ViewTeamsState();
}

class _ViewTeamsState extends State<ViewTeams> {
  List<Map<String, dynamic>> apiDataList = [];
  String? errorMessage;

  @override
  void initState() {
    super.initState();
    fetchData();
  }

  Future<void> fetchData() async {
    try {
      final response =
          await http.get(Uri.parse('${AppConfig.baseUrl}view_teams.php'));

      if (response.statusCode == 200) {
        final List<dynamic> data = json.decode(response.body);
        setState(() {
          apiDataList = data.cast<Map<String, dynamic>>();
        });
      } else {
        throw Exception('Failed to load data');
      }
    } catch (error) {
      print('Error fetching data: $error');
      // Handle the error appropriately (e.g., show an error message to the user)
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromARGB(255, 16, 99, 60),
        foregroundColor: const Color.fromARGB(255, 252, 252, 252),
        title: const Text(
          ' Team List ',
          style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
        ),
      ),
      body: Column(
        children: [
          if (apiDataList.isEmpty) const Text('No data available'),
          if (apiDataList.isNotEmpty)
            Expanded(
              child: SingleChildScrollView(
                scrollDirection: Axis.vertical,
                child: SingleChildScrollView(
                  scrollDirection: Axis.horizontal,
                  child: DataTableTheme(
                    data: DataTableThemeData(
                      headingRowColor: MaterialStateColor.resolveWith(
                          (states) => const Color.fromARGB(255, 0, 11, 22)!),
                      dataRowColor: MaterialStateColor.resolveWith(
                          (states) => const Color.fromARGB(255, 224, 224, 232)),
                    ),
                    child: DataTable(
                      columns: const [
                        DataColumn(
                          label: Text(
                            ' Team Name',
                            style: TextStyle(
                              color: Color.fromARGB(255, 244, 242, 242),
                              fontSize: 17,
                            ),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Address',
                            style: TextStyle(
                              color: Color.fromARGB(255, 244, 242, 242),
                              fontSize: 17,
                            ),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Manager',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Certificate No.',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Contact',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Action',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                      ],
                      rows: apiDataList.map((apiData) {
                        return DataRow(
                          cells: [
                            DataCell(
                              GestureDetector(
                                onTap: () {
                                  _navigateToeidtScreen(apiData);
                                },
                                child: Text(
                                  '${apiData['team_name']}',
                                  style: const TextStyle(
                                    color: Color.fromARGB(255, 0, 10, 7),
                                    fontWeight: FontWeight.bold,
                                    fontSize: 18,
                                  ),
                                ),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${apiData['address']}',
                                style: const TextStyle(
                                  color: Color.fromARGB(255, 0, 10, 7),
                                  fontWeight: FontWeight.bold,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${apiData['manager']}',
                                style: const TextStyle(
                                  color: Color.fromARGB(255, 0, 10, 7),
                                  fontWeight: FontWeight.bold,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${apiData['cert_num']}',
                                style: const TextStyle(
                                  color: Color.fromARGB(255, 0, 10, 7),
                                  fontWeight: FontWeight.bold,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${apiData['contact']}',
                                style: const TextStyle(
                                  color: Color.fromARGB(255, 0, 10, 7),
                                  fontWeight: FontWeight.bold,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                            DataCell(IconButton(
                              icon: const Icon(Icons.delete),
                              onPressed: () async {
                                bool confirmDelete = await showDialog(
                                  context: context,
                                  builder: (BuildContext context) {
                                    return AlertDialog(
                                      title: const Text('Confirm Deletion'),
                                      content: const Text(
                                          'Are you sure you want to delete this record?'),
                                      actions: <Widget>[
                                        TextButton(
                                          onPressed: () {
                                            Navigator.of(context).pop(
                                                false); // No, do not delete
                                          },
                                          child: const Text('No'),
                                        ),
                                        TextButton(
                                          onPressed: () {
                                            Navigator.of(context)
                                                .pop(true); // Yes, delete
                                          },
                                          child: const Text('Yes'),
                                        ),
                                      ],
                                    );
                                  },
                                );

                                if (confirmDelete == true) {
                                  // Handle delete action here
                                  // Perform the HTTP request to delete the record

                                  final response = await http.post(
                                    Uri.parse(
                                        '${AppConfig.baseUrl}delete_sales_product.php'),
                                    body: {
                                      'id':
                                          '${apiData['id']}', // Pass the ID of the egg to be deleted
                                    },
                                  );

                                  if (response.statusCode == 200) {
                                    setState(() {
                                      // Remove the item from the local list
                                      apiDataList.remove(apiData);

                                      final Map<String, dynamic> data =
                                          json.decode(response.body);
                                      final String message = data['message'];

                                      // Show alert dialog based on the message
                                      showDialog(
                                        context: context,
                                        builder: (BuildContext context) {
                                          return AlertDialog(
                                            title:
                                                const Text('Deletion Result'),
                                            content: Text(message),
                                            actions: <Widget>[
                                              TextButton(
                                                onPressed: () {
                                                  Navigator.of(context).pop();
                                                },
                                                child: const Text('OK'),
                                              ),
                                            ],
                                          );
                                        },
                                      );
                                    });
                                  } else {
                                    // Handle errors, print the status code for debugging
                                    print(
                                        'Error deleting record: ${response.statusCode}');
                                  }
                                }
                              },
                            ))
                          ],
                        );
                      }).toList(),
                    ),
                  ),
                ),
              ),
            ),
          const SizedBox(height: 20),
          ElevatedButton(
            onPressed: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => AddNewTeam()),
              );
            },
            style: ButtonStyle(
              backgroundColor: MaterialStateProperty.all<Color>(Colors.green),
              shape: MaterialStateProperty.all<OutlinedBorder>(
                RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                      20.0), // Adjust the radius as needed
                ),
              ),
            ),
            child: const Text(
              'Add New Team',
              style: TextStyle(
                  fontSize: 20, color: Color.fromARGB(255, 252, 252, 252)),
            ),
          )
        ],
      ),
    );
  }

  void _navigateToeidtScreen(Map<String, dynamic> productData) {
    Navigator.push(
      context,
      MaterialPageRoute(
        builder: (context) => PaymentScreen(
          teamname: productData['team_name'],
          address: productData['address'],
          manager: productData['manager'],
          contact: productData['contact'],
          status: productData['status'],
          myimage: '${AppConfig.baseUrl}${productData['image']}',
          teamid: productData['id'],
        ),
      ),
    );
  }
}

class PaymentScreen extends StatefulWidget {
  final String teamname;
  final String address;
  final String manager;
  final String contact;
  final String myimage;
  final String teamid;
  final String status;

  const PaymentScreen({
    Key? key,
    required this.teamname,
    required this.address,
    required this.manager,
    required this.contact,
    required this.myimage,
    required this.teamid,
    required this.status,
  }) : super(key: key);

  @override
  _PaymentScreenState createState() => _PaymentScreenState();
}

class _PaymentScreenState extends State<PaymentScreen> {
  late TextEditingController managerController;
  late TextEditingController addressController;
  late TextEditingController contactController;

  String selectedstatus = 'Inactive';

  final List<String> status = [
    'Inactive',
    'Active',
  ];

  @override
  void initState() {
    super.initState();

    managerController = TextEditingController();
    addressController = TextEditingController();
    contactController = TextEditingController();
  }

  @override
  void dispose() {
    managerController.dispose();
    addressController.dispose();
    contactController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: const Color.fromARGB(255, 16, 99, 60),
        foregroundColor: const Color.fromARGB(255, 252, 252, 252),
        title: const Text(
          'Edit Team Info. ',
          style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
        ),
      ),
      body: SingleChildScrollView(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            const SizedBox(height: 15),
            Text(
              'Team Name: ${widget.teamname}',
              style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 5),
            Text(
              'Address: ${widget.address}',
              style: const TextStyle(
                fontSize: 15,
                fontWeight: FontWeight.bold,
              ),
            ),
            const SizedBox(height: 5),
            Text(
              'Manager: ${widget.manager}',
              style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 5),
            Text(
              'Contact : ${widget.contact}',
              style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 5),
            Text(
              'Team Status : ${widget.status}',
              style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 5),
            Image.network(
              widget.myimage,
              width: 80,
              height: 80,
              errorBuilder: (context, error, stackTrace) {
                return const Placeholder(
                  fallbackWidth: 40,
                  fallbackHeight: 40,
                  color: Colors.grey, // Placeholder color
                );
              },
            ),
            Container(
              padding: const EdgeInsets.all(5),
              width: 300,
              child: TextField(
                //controller: TextEditingController(text: widget.address),
                controller: addressController,
                decoration: const InputDecoration(
                  labelText: 'Address',
                ),
              ),
            ),
            Container(
              padding: const EdgeInsets.all(5),
              width: 300,
              child: TextField(
                controller: managerController,
                decoration: const InputDecoration(
                  labelText: 'Manager',
                ),
              ),
            ),
            Container(
              padding: const EdgeInsets.all(5),
              width: 300,
              child: TextField(
                controller: contactController,
                decoration: const InputDecoration(
                  labelText: 'Contact',
                ),
              ),
            ),
            const SizedBox(height: 5),
            Container(
              padding: const EdgeInsets.all(5),
              width: 200,
              child: DropdownButtonFormField<String>(
                value: selectedstatus,
                onChanged: (value) {
                  setState(() {
                    selectedstatus = value!;
                  });
                },
                items: status.map((gender) {
                  return DropdownMenuItem<String>(
                    value: gender,
                    child: Text(gender),
                  );
                }).toList(),
                decoration: const InputDecoration(labelText: 'Team Status'),
              ),
            ),
            ElevatedButton(
              onPressed: () {
                postproduceData(
                    widget.teamid,
                    selectedstatus,
                    managerController.text,
                    addressController.text,
                    contactController.text);

                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                    builder: (context) => const ViewTeams(),
                  ),
                );
              },
              style: ButtonStyle(
                backgroundColor: MaterialStateProperty.all<Color>(Colors.green),
                shape: MaterialStateProperty.all<OutlinedBorder>(
                  RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(20.0),
                  ),
                ),
              ),
              child: const Text(
                'UpDate',
                style: TextStyle(
                  fontSize: 20,
                  color: Color.fromARGB(255, 252, 252, 252),
                ),
              ),
            )
          ],
        ),
      ),
    );
  }
}

void postproduceData(
  String teamid,
  String selectedstatus,
  String managerController,
  String addressController,
  String contactController,
) async {
  // Add your HTTP post request logic here
  // Use customerName, balance, and paymentAmount in your request

  final response = await http.post(
    Uri.parse(
        '${AppConfig.baseUrl}update_teams.php'), // Replace with your PHP endpoint
    body: {
      'teamid': teamid,
      'status': selectedstatus,
      'manager': managerController,
      'address': addressController,
      'contact': contactController,
    },
  );

  // Handle the response accordingly
  if (response.statusCode == 200) {
    print(selectedstatus);
    print(teamid);

    print('Manager $managerController');
    print('contact $contactController');
    print(addressController);

    // Successful request
    print('Udate successful');
  } else {
    print(selectedstatus);
    print(teamid);

    print('Manager $managerController');
    print('contact $contactController');
    print(addressController);
  }
}

//...........................add teams.......................................................................

class AddNewTeam extends StatefulWidget {
  @override
  _AddNewTeamState createState() => _AddNewTeamState();
}

class _AddNewTeamState extends State<AddNewTeam> {
  final TextEditingController nameController = TextEditingController();
  final TextEditingController addressController = TextEditingController();
  final TextEditingController managerController = TextEditingController();
  final TextEditingController contactController = TextEditingController();
  final TextEditingController certnumController = TextEditingController();

  File? _pickedImage;
  // Default group

  Future<void> _pickImage(ImageSource source) async {
    final pickedImageFile = await ImagePicker().pickImage(source: source);

    if (pickedImageFile == null) return;

    setState(() {
      _pickedImage = File(pickedImageFile.path);
    });
  }

  Future<void> uploadData() async {
    if (_pickedImage == null) {
      print('Please pick an image.');
      return;
    }

    final uri = Uri.parse('${AppConfig.baseUrl}add_new_team.php');

    final request = http.MultipartRequest('POST', uri)
      ..fields['team_name'] = nameController.text
      ..fields['address'] = addressController.text
      ..fields['contact'] = contactController.text
      ..fields['registration_num'] = certnumController.text
      ..fields['manager'] = managerController.text
      ..files.add(http.MultipartFile.fromBytes(
        'image',
        await _pickedImage!.readAsBytes(),
        filename: 'image.jpg',
      ));

    try {
      final response = await request.send();
      if (response.statusCode == 200) {
        print(nameController.text);
        print(addressController.text);
        print(contactController.text);
        print(certnumController.text);
        print(managerController.text);
        print('$_pickedImage');
        // ignore: use_build_context_synchronously
        Navigator.pushReplacement(
          context,
          MaterialPageRoute(
            builder: (context) => const ViewTeams(),
          ),
        );
      } else {
        print('Failed to upload image. Status code: ${response.statusCode}');
        print(request.headers);
      }
    } catch (e) {
      print('Error during image upload: $e');
      print(request.headers);
    }
  }

  @override
  void initState() {
    super.initState();
  }

  @override
  void dispose() {
    addressController.dispose();
    contactController.dispose();
    certnumController.dispose();
    nameController.dispose();
    managerController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          backgroundColor: Color.fromARGB(255, 16, 99, 60),
          title: const Text(
            'Add New Team',
            style: TextStyle(color: Colors.white), // Set text color to white
          ),
          iconTheme: const IconThemeData(color: Colors.white),
        ),
        body: Padding(
          padding: const EdgeInsets.all(16.0),
          child: SingleChildScrollView(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.stretch,
              children: [
                TextField(
                  controller: nameController,
                  decoration:
                      const InputDecoration(labelText: 'Enter Team Name'),
                ),
                const SizedBox(height: 10),
                const SizedBox(height: 10),
                TextField(
                  controller: addressController,
                  decoration: const InputDecoration(labelText: ' Team Address'),
                ),
                const SizedBox(height: 10),
                TextField(
                  controller: contactController,
                  decoration:
                      const InputDecoration(labelText: ' Contact Number'),
                ),
                const SizedBox(height: 10),
                TextField(
                  controller: managerController,
                  decoration: const InputDecoration(labelText: ' Manager Name'),
                ),
                const SizedBox(height: 10),
                TextField(
                  controller: certnumController,
                  decoration:
                      const InputDecoration(labelText: ' Registration Number'),
                ),
                const SizedBox(height: 10),
                ElevatedButton(
                  onPressed: () {
                    _pickImage(ImageSource.gallery);
                  },
                  style: ButtonStyle(
                    backgroundColor:
                        MaterialStateProperty.all<Color>(Colors.green),
                    shape: MaterialStateProperty.all<OutlinedBorder>(
                      RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(20.0),
                      ),
                    ),
                  ),
                  child: const Text(
                    'Select Team  Logo',
                    style: TextStyle(fontSize: 20, color: Colors.white),
                  ),
                ),
                const SizedBox(height: 10),
                _pickedImage != null
                    ? Image.file(_pickedImage!)
                    : const SizedBox.shrink(),
                const SizedBox(height: 20),
                ElevatedButton(
                  onPressed: () {
                    if (nameController.text.trim().isEmpty ||
                        contactController.text.trim().isEmpty ||
                        addressController.text.trim().isEmpty) {
                      showDialog(
                        context: context,
                        builder: (BuildContext context) {
                          return AlertDialog(
                            title: const Text('Add Teams'),
                            content: const Text(
                              "Please make sure that no field is empty",
                              style: TextStyle(
                                  fontSize: 20, fontWeight: FontWeight.bold),
                            ),
                            actions: <Widget>[
                              TextButton(
                                onPressed: () {
                                  Navigator.of(context).pop();
                                },
                                child: const Text(
                                  'OK',
                                  style: TextStyle(
                                      fontSize: 20,
                                      fontWeight: FontWeight.bold),
                                ),
                              ),
                            ],
                          );
                        },
                      );
                      return; // Return to avoid further execution if fields are empty
                    }

                    uploadData();
                    Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(
                        builder: (context) => const ViewTeams(),
                      ),
                    );
                  },
                  style: ButtonStyle(
                    backgroundColor:
                        MaterialStateProperty.all<Color>(Colors.green),
                    shape: MaterialStateProperty.all<OutlinedBorder>(
                      RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(20.0),
                      ),
                    ),
                  ),
                  child: const Text(
                    'Save',
                    style: TextStyle(fontSize: 20, color: Colors.white),
                  ),
                ),
              ],
            ),
          ),
        ));
  }
}
