<?php

// Database connection parameters


// Create connection
include 'conn.php';

// Fetch data from the database
$sql = "SELECT date as mydate, result_status, male_fixtures.id as fixtureid, CONCAT(MONTHNAME(date), ' ', DAY(date), ', ', YEAR(date), ' ', TIME(date)) AS formatted_date, home_team_name, home.image as home_team_image, away_team_name, away.image as away_team_image FROM male_fixtures JOIN teams_table as home ON male_fixtures.home_team_name = home.team_name JOIN teams_table as away ON male_fixtures.away_team_name = away.team_name where date <= current_date and result_status != 'Updated' ORDER BY date ASC";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Output data in JSON format
    $data = array();
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    echo json_encode($data);
} else {
    echo "No data found";
}

$conn->close();

?>




