<?php
// Establish database connection
include 'conn.php';

// Fetch match results data from the result table
$sql = "SELECT
            home_team_name,
            away_team_name,
            home_team_goals,
            away_team_goals
        FROM
            results";

$result = $conn->query($sql);

// Check if there are results
if ($result->num_rows > 0) {
    // Initialize team statistics
    $teams = [];

    // Process match results
    while ($row = $result->fetch_assoc()) {
        $home_team = $row['home_team_name'];
        $away_team = $row['away_team_name'];
        $home_goals = (int)$row['home_team_goals'];
        $away_goals = (int)$row['away_team_goals'];

        // Update home team statistics
        if (!isset($teams[$home_team])) {
            $teams[$home_team] = ['points' => 0, 'goals_scored' => 0, 'goals_against' => 0];
        }
        $teams[$home_team]['points'] += $home_goals > $away_goals ? 3 : ($home_goals === $away_goals ? 1 : 0);
        $teams[$home_team]['goals_scored'] += $home_goals;
        $teams[$home_team]['goals_against'] += $away_goals;

        // Update away team statistics
        if (!isset($teams[$away_team])) {
            $teams[$away_team] = ['points' => 0, 'goals_scored' => 0, 'goals_against' => 0];
        }
        $teams[$away_team]['points'] += $away_goals > $home_goals ? 3 : ($away_goals === $home_goals ? 1 : 0);
        $teams[$away_team]['goals_scored'] += $away_goals;
        $teams[$away_team]['goals_against'] += $home_goals;
    }

    // Sort teams based on points, goal difference, and goals scored
    uasort($teams, function($a, $b) {
        if ($a['points'] !== $b['points']) {
            return $b['points'] - $a['points'];
        }
        $diff_a = $a['goals_scored'] - $a['goals_against'];
        $diff_b = $b['goals_scored'] - $b['goals_against'];
        if ($diff_a !== $diff_b) {
            return $diff_b - $diff_a;
        }
        return $b['goals_scored'] - $a['goals_scored'];
    });

    // Display the table
    echo '<table>';
    echo '<tr><th>Position</th><th>Team</th><th>Points</th><th>Goals Scored</th><th>Goals Against</th></tr>';
    $position = 1;
    foreach ($teams as $team => $stats) {
        echo '<tr>';
        echo '<td>' . $position++ . '</td>';
        echo '<td>' . $team . '</td>';
        echo '<td>' . $stats['points'] . '</td>';
        echo '<td>' . $stats['goals_scored'] . '</td>';
        echo '<td>' . $stats['goals_against'] . '</td>';
        echo '</tr>';
    }
    echo '</table>';
} else {
    // No results found
    echo "No match results found";
}

// Close the database connection
$conn->close();
?>
