<?php
require 'vendor/autoload.php'; // Include the library

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

// Establish database connection (replace with your actual credentials)
include 'conn.php';

if (!$conn) {
  echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
  exit; // Stop script execution if connection fails
}

$target_dir = "uploads/"; // Directory to store uploaded files
$target_file = $target_dir . basename($_FILES["excel"]["name"]);

if (move_uploaded_file($_FILES["excel"]["tmp_name"], $target_file)) {
  $reader = new Xlsx();
  $spreadsheet = $reader->load($target_file);
  $worksheet = $spreadsheet->getActiveSheet();

  $highestRow = $worksheet->getHighestRow();
  $highestColumn = $worksheet->getHighestColumn();

  $data = [];
  for ($row = 1; $row <= $highestRow; $row++) {
    $rowData = [];
    for ($col = 'A'; $col <= $highestColumn; $col++) {
      $rowData[] = $worksheet->getCell($col . $row)->getValue();
    }
    // Log or print extracted data for debugging
    error_log(print_r($rowData, true));

    $data[] = $rowData;
  }

  // Prepare INSERT query
  foreach ($data as $rowIndex => $row) {
    // Check if the data already exists
    $checkSql = "SELECT COUNT(*) FROM male_fixtures WHERE home_team_name = ? AND away_team_name = ? AND date = ?";
    $checkStmt = $conn->prepare($checkSql);
    $checkStmt->bind_param("sss", $row[0], $row[1], $row[2]);
    $checkStmt->execute();
    $checkResult = $checkStmt->get_result();
    $count = $checkResult->fetch_row()[0];
    
    if ($count > 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "Data already exists on row " . ($rowIndex + 1)
        ]);
    } else {
        // Insert the data
        $insertSql = "INSERT INTO male_fixtures (home_team_name, away_team_name, date) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($insertSql);
        $stmt->bind_param("sss", $row[0], $row[1], $row[2]);
        
        if (!$stmt->execute()) {
            echo json_encode([
                'status' => 'error',
                'message' => "Error inserting data on row " . ($rowIndex + 1) . ": (" . $stmt->errno . ") " . $stmt->error
            ]);
        }
    }
}


  echo json_encode(['status' => 'success']);
} else {
  // Handle potential upload errors
  echo json_encode(['status' => 'error', 'message' => 'Error uploading file']);
}
