<?php
// Establish database connection
include 'conn.php';

// Fetch match results data from the result table
$sql = "SELECT
            home_team_name,
            away_team_name,
            home_team_goals,
            away_team_goals,
            home_team_image,
            away_team_image
        FROM
            results";

$result = $conn->query($sql);

// Check if there are results
if ($result->num_rows > 0) {
    // Initialize team statistics
    $teams = [];

    // Process match results
    while ($row = $result->fetch_assoc()) {
        $home_team = $row['home_team_name'];
        $away_team = $row['away_team_name'];
        $home_goals = (int)$row['home_team_goals'];
        $away_goals = (int)$row['away_team_goals'];
        $home_image = $row['home_team_image'];
        $away_image = $row['away_team_image'];

        // Update home team statistics
        if (!isset($teams[$home_team])) {
            $teams[$home_team] = ['points' => 0, 'games_played' => 0, 'wins' => 0, 'draws' => 0, 'losses' => 0, 'goals_scored' => 0, 'goals_against' => 0, 'image' => $home_image];
        }
        $teams[$home_team]['games_played']++;
        $teams[$home_team]['goals_scored'] += $home_goals;
        $teams[$home_team]['goals_against'] += $away_goals;
        if ($home_goals > $away_goals) {
            $teams[$home_team]['wins']++;
            $teams[$home_team]['points'] += 3;
        } elseif ($home_goals === $away_goals) {
            $teams[$home_team]['draws']++;
            $teams[$home_team]['points'] += 1;
        } else {
            $teams[$home_team]['losses']++;
        }

        // Update away team statistics
        if (!isset($teams[$away_team])) {
            $teams[$away_team] = ['points' => 0, 'games_played' => 0, 'wins' => 0, 'draws' => 0, 'losses' => 0, 'goals_scored' => 0, 'goals_against' => 0, 'image' => $away_image];
        }
        $teams[$away_team]['games_played']++;
        $teams[$away_team]['goals_scored'] += $away_goals;
        $teams[$away_team]['goals_against'] += $home_goals;
        if ($away_goals > $home_goals) {
            $teams[$away_team]['wins']++;
            $teams[$away_team]['points'] += 3;
        } elseif ($away_goals === $home_goals) {
            $teams[$away_team]['draws']++;
            $teams[$away_team]['points'] += 1;
        } else {
            $teams[$away_team]['losses']++;
        }
    }

    // Sort teams based on points, goal difference, and goals scored
    uasort($teams, function($a, $b) {
        if ($a['points'] !== $b['points']) {
            return $b['points'] - $a['points'];
        }
        $diff_a = $a['goals_scored'] - $a['goals_against'];
        $diff_b = $b['goals_scored'] - $b['goals_against'];
        if ($diff_a !== $diff_b) {
            return $diff_b - $diff_a;
        }
        return $b['goals_scored'] - $a['goals_scored'];
    });

    // Assign positions to teams
    $position = 1;
    foreach ($teams as &$team) {
        $team['position'] = $position++;
        $team['goal_difference'] = $team['goals_scored'] - $team['goals_against'];
    }
    unset($team); // Unset reference to last element

    // Convert team statistics to JSON
    $json_data = json_encode($teams);

    // Output JSON data
    header('Content-Type: application/json');
    echo $json_data;
} else {
    // No results found
    echo json_encode(['error' => 'No match results found']);
}

// Close the database connection
$conn->close();
?>
