import 'package:flutter/material.dart';
import 'package:slpl_app/admin.dart';
import 'package:slpl_app/main.dart';
import 'package:slpl_app/malefootballresult.dart';
import 'mentable.dart';
import 'package:http/http.dart' as http;
import 'dart:convert';
import 'package:intl/intl.dart';
import 'config.dart';

class FixtureScreen extends StatefulWidget {
  @override
  _FixtureScreenState createState() => _FixtureScreenState();
}

class _FixtureScreenState extends State<FixtureScreen> {
  List<Fixture> fixtures = [];
  String? errorMessage;

  @override
  void initState() {
    super.initState();
    fetchFixtures();
  }

  Future<void> fetchFixtures() async {
    try {
      final response =
          await http.get(Uri.parse('${AppConfig.baseUrl}/male_fixtures.php'));

      if (response.statusCode == 200) {
        List<dynamic> data = json.decode(response.body);
        setState(() {
          fixtures = data.map((item) => Fixture.fromJson(item)).toList();
        });
      } else {
        throw Exception('Failed to load fixtures');
      }
    } catch (e) {
      fixtures = [];
      errorMessage = 'No data found';
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
          backgroundColor: Color.fromARGB(255, 16, 99, 60),
          foregroundColor: const Color.fromARGB(255, 252, 252, 252),
          leading: IconButton(
            icon: Icon(Icons.arrow_back),
            onPressed: () {
              // Navigate back when the back button is pressed
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => const SlplApp()),
              );
            },
          ),
          title: Container(
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
            ),
            child: const Text(
              "Fixtures",
              style: TextStyle(
                color: Color.fromARGB(255, 246, 247, 248),
                fontSize: 18,
                fontWeight: FontWeight.bold,
              ),
            ),
          ),
          actions: [
            PopupMenuButton(
              itemBuilder: (context) {
                return [
                  const PopupMenuItem<int>(
                    value: 0,
                    child: Text(
                      "Transfer News",
                      style: TextStyle(fontWeight: FontWeight.bold),
                    ),
                  ),
                  const PopupMenuItem<int>(
                    value: 1,
                    child: Text(
                      "Results",
                      style: TextStyle(fontWeight: FontWeight.bold),
                    ),
                  ),
                  const PopupMenuItem<int>(
                    value: 2,
                    child: Text(
                      "Sponsorship",
                      style: TextStyle(fontWeight: FontWeight.bold),
                    ),
                  ),
                  const PopupMenuItem<int>(
                    value: 3,
                    child: Text(
                      "Goals",
                      style: TextStyle(fontWeight: FontWeight.bold),
                    ),
                  ),
                  const PopupMenuItem<int>(
                    value: 4,
                    child: Text(
                      "Table",
                      style: TextStyle(fontWeight: FontWeight.bold),
                    ),
                  ),
                  const PopupMenuItem<int>(
                    value: 5,
                    child: Text(
                      "Admin",
                      style: TextStyle(fontWeight: FontWeight.bold),
                    ),
                  ),
                ];
              },
              onSelected: (value) {
                // Handle menu item selection
                if (value == 0) {}
                // Handle menu item selection

                if (value == 1) {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                        builder: (context) => MaleFootballResults()),
                  );
                }
                if (value == 2) {}

                if (value == 3) {}
                if (value == 4) {
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => const MyMenTable()),
                  );
                }
                if (value == 5) {
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => LeagueAdmin()),
                  );
                }
                // Handle menu item selection
              },
            ),
          ]),
      body: ListView.builder(
        itemCount: fixtures.length,
        itemBuilder: (context, index) {
          return Center(
            child: Column(
              children: [
                // Formatted Date
                const SizedBox(height: 10), // Add spacing
                Text(
                  DateFormat('MMMM dd, yyyy - HH:mm')
                      .format(fixtures[index].date),
                  style: const TextStyle(fontWeight: FontWeight.bold),
                ),

                const SizedBox(height: 10), // Add spacing

                // Fixture details (remains unchanged)
                Row(
                  mainAxisAlignment:
                      MainAxisAlignment.center, // Center the Row content
                  children: [
                    // Home Team
                    Column(
                      children: [
                        Image.network(
                          fixtures[index].homeTeamImage,
                          width: 30,
                          height: 30,
                        ),
                        Text(
                          '${fixtures[index].homeTeamName}',
                          style: TextStyle(fontWeight: FontWeight.bold),
                        ),
                      ],
                    ),
                    const SizedBox(
                        width:
                            50), // Adjust spacing between home team and "VS" text

                    // "vs" Text
                    const Text(
                      'vs',
                      style: TextStyle(fontWeight: FontWeight.bold),
                    ),
                    const SizedBox(
                        width:
                            50), // Adjust spacing between "VS" text and away team

                    // Away Team
                    Column(
                      children: [
                        Image.network(
                          fixtures[index].awayTeamImage,
                          width: 30,
                          height: 30,
                        ),
                        Text(
                          '${fixtures[index].awayTeamName}',
                          style: TextStyle(fontWeight: FontWeight.bold),
                        ),
                      ],
                    ),
                  ],
                ),
                const Divider(), // Add divider between fixtures
              ],
            ),
          );
        },
      ),
    );
  }
}

class Fixture {
  final DateTime date;
  final String homeTeamName;
  final String homeTeamImage;
  final String awayTeamName;
  final String awayTeamImage;

  Fixture({
    required this.date,
    required this.homeTeamName,
    required this.homeTeamImage,
    required this.awayTeamName,
    required this.awayTeamImage,
  });

  factory Fixture.fromJson(Map<String, dynamic> json) {
    // Split the date string by whitespace
    final dateParts = json['formatted_date'].toString().split(' ');

    // Extract individual date components
    final month = dateParts[0]; // Month string
    final day = int.parse(dateParts[1].replaceAll(',', '')); // Day as integer
    final year = int.parse(dateParts[2]); // Year as integer
    final time = dateParts[3]; // Time string

    // Extract hour and minute from time string
    final timeParts = time.split(':');
    final hour = int.parse(timeParts[0]);
    final minute = int.parse(timeParts[1]);

    // Convert month name to its corresponding number
    final monthNumber = _getMonthNumber(month);

    // Construct DateTime object
    return Fixture(
      date: DateTime(year, monthNumber, day, hour, minute),
      homeTeamName: json['home_team_name'],
      homeTeamImage:
          'http://192.168.100.15/slpl_app/${json['home_team_image']}',
      awayTeamName: json['away_team_name'],
      awayTeamImage:
          'http://192.168.100.15/slpl_app/${json['away_team_image']}',
    );
  }

  static int _getMonthNumber(String month) {
    switch (month) {
      case 'January':
        return 1;
      case 'February':
        return 2;
      case 'March':
        return 3;
      case 'April':
        return 4;
      case 'May':
        return 5;
      case 'June':
        return 6;
      case 'July':
        return 7;
      case 'August':
        return 8;
      case 'September':
        return 9;
      case 'October':
        return 10;
      case 'November':
        return 11;
      case 'December':
        return 12;
      default:
        throw Exception('Invalid month: $month');
    }
  }
}

void main() {
  runApp(MyApp());
}

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Football App',
      theme: ThemeData(
        primarySwatch: Colors.blue,
      ),
      home: FixtureScreen(),
    );
  }
}
