import 'package:flutter/material.dart';
import 'package:slpl_app/main.dart';
import 'package:slpl_app/newsdetails.dart';

class News extends StatelessWidget {
  const News({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter Demo',
      theme: ThemeData(
        // colorScheme: ColorScheme.fromSwatch(primarySwatch: Colors.blue),
        useMaterial3: true,
      ),
      home: FootballNewsScreen(),
    );
  }
}

class FootballNewsScreen extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromARGB(255, 16, 99, 60),
        foregroundColor: const Color.fromARGB(255, 252, 252, 252),
        leading: IconButton(
          icon: Icon(Icons.arrow_back),
          onPressed: () {
            // Navigate back when the back button is pressed
            Navigator.push(
              context,
              MaterialPageRoute(builder: (context) => const SlplApp()),
            );
          },
        ),
        title: Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(8),
          ),
          child: const Text(
            "News Headlines",
            style: TextStyle(
              color: Color.fromARGB(255, 246, 247, 248),
              fontSize: 20,
              fontWeight: FontWeight.bold,
            ),
          ),
        ),
      ),
      body: ListView.builder(
        itemCount: 1, // Adjust the number of news articles as needed
        itemBuilder: (context, index) {
          return Padding(
            padding: const EdgeInsets.all(8.0),
            child: Card(
              elevation: 2,
              child: ListTile(
                title: const Text(
                  'SPORTS MINISTER WITNESSES ANNUAL SQUASH GRAND FINAL ',
                  style: TextStyle(fontWeight: FontWeight.bold, fontSize: 14),
                ),
                subtitle: const Text(
                    'Minister of Sports Madam Augusta James-Teima last Saturday witnessed the Squash Association Annual Tournament Grand Final held at the Squash Complex, YSC.'),
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                        builder: (context) => const Newsdetails()),
                  );
                },
              ),
            ),
          );
        },
      ),
    );
  }
}

void main() {
  runApp(const News());
}
