// ignore_for_file: use_build_context_synchronously

import 'dart:io';
import 'config.dart';
import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;
import 'dart:convert';
import 'dart:async';
import 'package:image_picker/image_picker.dart';

//import 'package:shared_preferences/shared_preferences.dart';

class ViewLeagues extends StatefulWidget {
  const ViewLeagues({super.key});

  @override
  _ViewLeaguesState createState() => _ViewLeaguesState();
}

class _ViewLeaguesState extends State<ViewLeagues> {
  List<Map<String, dynamic>> eggDataList = [];
  String? errorMessage;

  @override
  void initState() {
    super.initState();
    fetchData();
  }

  Future<void> fetchData() async {
    try {
      final response =
          await http.get(Uri.parse('${AppConfig.baseUrl}view_all_leagues.php'));

      if (response.statusCode == 200) {
        final List<dynamic> data = json.decode(response.body);
        setState(() {
          eggDataList = data.cast<Map<String, dynamic>>();
        });
      } else {
        throw Exception('Failed to load data');
      }
    } catch (error) {
      print('Error fetching data: $error');
      // Handle the error appropriately (e.g., show an error message to the user)
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromARGB(255, 16, 99, 60),
        foregroundColor: const Color.fromARGB(255, 252, 252, 252),
        title: const Text(
          ' League List ',
          style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
        ),
      ),
      body: Column(
        children: [
          if (eggDataList.isEmpty) const Text('No data available'),
          if (eggDataList.isNotEmpty)
            Expanded(
              child: SingleChildScrollView(
                scrollDirection: Axis.vertical,
                child: SingleChildScrollView(
                  scrollDirection: Axis.horizontal,
                  child: DataTableTheme(
                    data: DataTableThemeData(
                      headingRowColor: MaterialStateColor.resolveWith(
                          (states) => const Color.fromARGB(255, 0, 11, 22)!),
                      dataRowColor: MaterialStateColor.resolveWith(
                          (states) => const Color.fromARGB(255, 224, 224, 232)),
                    ),
                    child: DataTable(
                      columns: const [
                        DataColumn(
                          label: Text(
                            ' League Title',
                            style: TextStyle(
                              color: Color.fromARGB(255, 244, 242, 242),
                              fontSize: 17,
                            ),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Start Date',
                            style: TextStyle(
                              color: Color.fromARGB(255, 244, 242, 242),
                              fontSize: 17,
                            ),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'End Date',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Status',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'View teams',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Action',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                      ],
                      rows: eggDataList.map((eggData) {
                        return DataRow(
                          cells: [
                            DataCell(
                              GestureDetector(
                                onTap: () {
                                  _navigateToeidtScreen(eggData);
                                },
                                child: Text(
                                  '${eggData['title']}',
                                  style: const TextStyle(
                                    color: Color.fromARGB(255, 0, 10, 7),
                                    fontWeight: FontWeight.bold,
                                    fontSize: 18,
                                  ),
                                ),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${eggData['startdate']}',
                                style: const TextStyle(
                                  color: Color.fromARGB(255, 0, 10, 7),
                                  fontWeight: FontWeight.bold,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${eggData['enddate']}',
                                style: const TextStyle(
                                  color: Color.fromARGB(255, 0, 10, 7),
                                  fontWeight: FontWeight.bold,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${eggData['league_status']}',
                                style: const TextStyle(
                                  color: Color.fromARGB(255, 0, 10, 7),
                                  fontWeight: FontWeight.bold,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                            DataCell(
                              IconButton(
                                iconSize: 20,
                                icon: const Icon(Icons.groups),
                                onPressed: () async {
                                  // Handle fetching teams for a specific league
                                  const String url =
                                      '${AppConfig.baseUrl}get_leagues_by_year.php';
                                  // Replace 'your_league_id' with the actual league ID

                                  try {
                                    final response = await http.post(
                                      Uri.parse(url),
                                      body: {
                                        'league_name': '${eggData['title']}'
                                      },
                                    );

                                    if (response.statusCode == 200) {
                                      print('${eggData['id']}');
                                      // Parse response body for the list of teams
                                      final List<dynamic> responseData =
                                          jsonDecode(response.body);

                                      showDialog(
                                        context: context,
                                        builder: (BuildContext context) {
                                          return AlertDialog(
                                            title: Text(
                                                '${eggData['title']} Teams'),
                                            content: SingleChildScrollView(
                                              child: Column(
                                                mainAxisSize: MainAxisSize.min,
                                                children: [
                                                  for (var teamData
                                                      in responseData)
                                                    ListTile(
                                                      title: Text(teamData[
                                                          'team_name']),
                                                    ),
                                                ],
                                              ),
                                            ),
                                            actions: [
                                              TextButton(
                                                onPressed: () {
                                                  Navigator.of(context).pop();
                                                },
                                                child: const Text('Close'),
                                              ),
                                            ],
                                          );
                                        },
                                      );
                                    } else {
                                      // Handle other response statuses
                                      print('Error: ${response.statusCode}');
                                      // You might want to show an error message to the user
                                    }
                                  } catch (e) {
                                    // Handle network or other errors
                                    print('Error: $e');
                                    // You might want to show an error message to the user
                                  }
                                },
                              ),
                            ),
                            DataCell(IconButton(
                              icon: const Icon(Icons.delete),
                              onPressed: () async {
                                bool confirmDelete = await showDialog(
                                  context: context,
                                  builder: (BuildContext context) {
                                    return AlertDialog(
                                      title: const Text('Confirm Deletion'),
                                      content: const Text(
                                          'Are you sure you want to delete this record?'),
                                      actions: <Widget>[
                                        TextButton(
                                          onPressed: () {
                                            Navigator.of(context).pop(
                                                false); // No, do not delete
                                          },
                                          child: const Text('No'),
                                        ),
                                        TextButton(
                                          onPressed: () {
                                            Navigator.of(context)
                                                .pop(true); // Yes, delete
                                          },
                                          child: const Text('Yes'),
                                        ),
                                      ],
                                    );
                                  },
                                );

                                if (confirmDelete == true) {
                                  // Handle delete action here
                                  // Perform the HTTP request to delete the record

                                  final response = await http.post(
                                    Uri.parse(
                                        '${AppConfig.baseUrl}delete_sales_product.php'),
                                    body: {
                                      'id':
                                          '${eggData['id']}', // Pass the ID of the egg to be deleted
                                    },
                                  );

                                  if (response.statusCode == 200) {
                                    setState(() {
                                      // Remove the item from the local list
                                      eggDataList.remove(eggData);

                                      final Map<String, dynamic> data =
                                          json.decode(response.body);
                                      final String message = data['message'];

                                      // Show alert dialog based on the message
                                      showDialog(
                                        context: context,
                                        builder: (BuildContext context) {
                                          return AlertDialog(
                                            title:
                                                const Text('Deletion Result'),
                                            content: Text(message),
                                            actions: <Widget>[
                                              TextButton(
                                                onPressed: () {
                                                  Navigator.of(context).pop();
                                                },
                                                child: const Text('OK'),
                                              ),
                                            ],
                                          );
                                        },
                                      );
                                    });
                                  } else {
                                    // Handle errors, print the status code for debugging
                                    print(
                                        'Error deleting record: ${response.statusCode}');
                                  }
                                }
                              },
                            ))
                          ],
                        );
                      }).toList(),
                    ),
                  ),
                ),
              ),
            ),
          const SizedBox(height: 20),
          ElevatedButton(
            onPressed: () {
              Navigator.pop(context);
              Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => CreateNewLeague()),
              );
            },
            style: ButtonStyle(
              backgroundColor: MaterialStateProperty.all<Color>(Colors.green),
              shape: MaterialStateProperty.all<OutlinedBorder>(
                RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                      20.0), // Adjust the radius as needed
                ),
              ),
            ),
            child: const Text(
              'Add New League',
              style: TextStyle(
                  fontSize: 20, color: Color.fromARGB(255, 252, 252, 252)),
            ),
          )
        ],
      ),
    );
  }

  void _navigateToeidtScreen(Map<String, dynamic> productData) {
    Navigator.push(
      context,
      MaterialPageRoute(
        builder: (context) => PaymentScreen(
          leaguename: productData['title'],
          description: productData['description'],
          startdate: productData['startdate'],
          enddate: productData['enddate'],
          leaguestatus: productData['league_status'],
          leagueid: productData['id'],
        ),
      ),
    );
  }
}

class PaymentScreen extends StatefulWidget {
  final String leaguename;
  final String description;
  final String startdate;
  final String enddate;
  final String leaguestatus;
  final String leagueid;

  const PaymentScreen({
    Key? key,
    required this.leaguename,
    required this.description,
    required this.startdate,
    required this.enddate,
    required this.leaguestatus,
    required this.leagueid,
  }) : super(key: key);

  @override
  _PaymentScreenState createState() => _PaymentScreenState();
}

class _PaymentScreenState extends State<PaymentScreen> {
  late TextEditingController commissionController;
  late TextEditingController mydetailsController;
  late TextEditingController startdateController;
  late TextEditingController endradeController;
  String selectedstatus = 'Inactive';

  final List<String> status = [
    'Inactive',
    'Active',
  ];

  DateTime selectedDate = DateTime.now();

  Future<void> _selectDate(BuildContext context) async {
    final DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: selectedDate,
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null && pickedDate != selectedDate) {
      setState(() {
        selectedDate = pickedDate;
      });
    }
  }

  @override
  void initState() {
    super.initState();

    mydetailsController = TextEditingController();
    startdateController = TextEditingController();
    endradeController = TextEditingController();
  }

  @override
  void dispose() {
    mydetailsController.dispose();
    startdateController.dispose();
    endradeController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromARGB(255, 16, 99, 60),
        foregroundColor: const Color.fromARGB(255, 252, 252, 252),
        title: const Text(
          'Edit League',
          style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
        ),
      ),
      body: SingleChildScrollView(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            const SizedBox(height: 15),
            Text(
              'League Name: ${widget.leaguename}',
              style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 5),
            Container(
              padding: const EdgeInsets.all(20),
              width: 400,
              child: Text(
                'Description: ${widget.description}',
                style: const TextStyle(
                  fontSize: 15,
                ),
              ),
            ),
            const SizedBox(height: 5),
            Text(
              'Status ${widget.leaguestatus}',
              style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 5),
            Text(
              'Start Date : ${widget.startdate}',
              style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
            ),
            const SizedBox(height: 5),
            Text(
              'End Date: ${widget.enddate}',
              style: const TextStyle(fontSize: 15, fontWeight: FontWeight.bold),
            ),
            Container(
              padding: const EdgeInsets.all(5),
              width: 400,
              child: TextField(
                controller: startdateController,
                onTap: () async {
                  DateTime? pickedDate = await showDatePicker(
                    context: context,
                    initialDate: DateTime.now(),
                    firstDate: DateTime(2000),
                    lastDate: DateTime(2101),
                  );
                  if (pickedDate != null) {
                    setState(() {
                      startdateController.text =
                          pickedDate.toString(); // Update text field value
                    });
                  }
                },
                decoration: const InputDecoration(
                  labelText: 'Select Start Date',
                  suffixIcon: Icon(Icons.calendar_today),
                ),
              ),
            ),
            Container(
                padding: const EdgeInsets.all(5),
                width: 400,
                child: TextField(
                  controller: endradeController,
                  onTap: () async {
                    DateTime? pickedDate = await showDatePicker(
                      context: context,
                      initialDate: DateTime.now(),
                      firstDate: DateTime(2000),
                      lastDate: DateTime(2101),
                    );
                    if (pickedDate != null) {
                      setState(() {
                        endradeController.text =
                            pickedDate.toString(); // Update text field value
                      });
                    }
                  },
                  decoration: const InputDecoration(
                    labelText: 'Select End Date',
                    suffixIcon: Icon(Icons.calendar_today),
                  ),
                )),
            Container(
              padding: const EdgeInsets.all(5),
              width: 400,
              child: TextField(
                controller: mydetailsController,
                decoration: const InputDecoration(
                  labelText: 'Details',
                ),
              ),
            ),
            const SizedBox(height: 5),
            Container(
              padding: const EdgeInsets.all(5),
              width: 200,
              child: DropdownButtonFormField<String>(
                value: selectedstatus,
                onChanged: (value) {
                  setState(() {
                    selectedstatus = value!;
                  });
                },
                items: status.map((gender) {
                  return DropdownMenuItem<String>(
                    value: gender,
                    child: Text(gender),
                  );
                }).toList(),
                decoration: const InputDecoration(labelText: 'League Status'),
              ),
            ),
            ElevatedButton(
              onPressed: () {
                postproduceData(
                  widget.leagueid,
                  selectedstatus,
                  widget.startdate,
                  widget.enddate,
                  mydetailsController.text,
                  startdateController.text,
                  endradeController.text,
                );

                Navigator.pushReplacement(
                  context,
                  MaterialPageRoute(
                    builder: (context) => const ViewLeagues(),
                  ),
                );
              },
              style: ButtonStyle(
                backgroundColor: MaterialStateProperty.all<Color>(Colors.green),
                shape: MaterialStateProperty.all<OutlinedBorder>(
                  RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(20.0),
                  ),
                ),
              ),
              child: const Text(
                'UpDate',
                style: TextStyle(
                  fontSize: 20,
                  color: Color.fromARGB(255, 252, 252, 252),
                ),
              ),
            )
          ],
        ),
      ),
    );
  }
}

void postproduceData(
  String leagueid,
  String selectedstatus,
  String startdate,
  String enddate,
  String mydetailsController,
  String startdateController,
  String endradeController,
) async {
  // Add your HTTP post request logic here
  // Use customerName, balance, and paymentAmount in your request

  final response = await http.post(
    Uri.parse(
        '${AppConfig.baseUrl}update_league.php'), // Replace with your PHP endpoint
    body: {
      'league_id': leagueid,
      'status': selectedstatus,
      'startdate': startdateController,
      'enddate': endradeController,
      'newdetailes': mydetailsController,
    },
  );

  // Handle the response accordingly
  if (response.statusCode == 200) {
    print(selectedstatus);
    print(leagueid);

    print('start date $startdateController');
    print('end date $endradeController');
    print(mydetailsController);

    // Successful request
    print('Udate successful');
  } else {
    print(selectedstatus);
    print(leagueid);

    print('end date $startdateController');
    print('end date $endradeController');
    print(mydetailsController);
  }
}

//...........................Create League.........................................................................

class CreateNewLeague extends StatefulWidget {
  @override
  _CreateNewLeagueState createState() => _CreateNewLeagueState();
}

class _CreateNewLeagueState extends State<CreateNewLeague> {
  final TextEditingController nameController = TextEditingController();
  final TextEditingController descriptionController = TextEditingController();

  final TextEditingController endradeController = TextEditingController();
  TextEditingController startdateController = TextEditingController();

  File? _pickedImage;
  // Default group

  DateTime selectedDate = DateTime.now();

  Future<void> _selectDate(BuildContext context) async {
    final DateTime? pickedDate = await showDatePicker(
      context: context,
      initialDate: selectedDate,
      firstDate: DateTime(2000),
      lastDate: DateTime(2101),
    );
    if (pickedDate != null && pickedDate != selectedDate) {
      setState(() {
        selectedDate = pickedDate;
      });
    }
  }

  Future<void> _pickImage(ImageSource source) async {
    final pickedImageFile = await ImagePicker().pickImage(source: source);

    if (pickedImageFile == null) return;

    setState(() {
      _pickedImage = File(pickedImageFile.path);
    });
  }

  Future<void> uploadData() async {
    if (_pickedImage == null) {
      print('Please pick an image.');
      return;
    }

    final uri = Uri.parse('${AppConfig.baseUrl}create_league.php');

    final request = http.MultipartRequest('POST', uri)
      ..fields['name'] = nameController.text
      ..fields['description'] = descriptionController.text
      ..fields['startdate'] = startdateController.text
      ..fields['enddate'] = endradeController.text
      ..files.add(http.MultipartFile.fromBytes(
        'image',
        await _pickedImage!.readAsBytes(),
        filename: 'image.jpg',
      ));

    try {
      final response = await request.send();
      if (response.statusCode == 200) {
        print(nameController.text);
        print(descriptionController.text);
        print(startdateController.text);
        print(endradeController);
        print('$_pickedImage');
        // ignore: use_build_context_synchronously
        Navigator.pushReplacement(
          context,
          MaterialPageRoute(
            builder: (context) => const ViewLeagues(),
          ),
        );
      } else {
        print('Failed to upload image. Status code: ${response.statusCode}');
        print(request.headers);
      }
    } catch (e) {
      print('Error during image upload: $e');
      print(request.headers);
    }
  }

  @override
  void initState() {
    super.initState();
  }

  @override
  void dispose() {
    startdateController.dispose();
    endradeController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          backgroundColor: Color.fromARGB(255, 16, 99, 60),
          title: const Text(
            'Add New League',
            style: TextStyle(color: Colors.white), // Set text color to white
          ),
          iconTheme: const IconThemeData(color: Colors.white),
        ),
        body: Padding(
          padding: const EdgeInsets.all(16.0),
          child: SingleChildScrollView(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.stretch,
              children: [
                TextField(
                  controller: nameController,
                  decoration:
                      const InputDecoration(labelText: 'Enter league Title'),
                ),
                const SizedBox(height: 10),
                const SizedBox(height: 10),
                TextField(
                  controller: descriptionController,
                  decoration:
                      const InputDecoration(labelText: ' League Description'),
                ),
                const SizedBox(height: 10),
                TextField(
                  controller: startdateController,
                  onTap: () async {
                    DateTime? pickedDate = await showDatePicker(
                      context: context,
                      initialDate: DateTime.now(),
                      firstDate: DateTime(2000),
                      lastDate: DateTime(2101),
                    );
                    if (pickedDate != null) {
                      setState(() {
                        startdateController.text =
                            pickedDate.toString(); // Update text field value
                      });
                    }
                  },
                  decoration: const InputDecoration(
                    labelText: 'Select Start Date',
                    suffixIcon: Icon(Icons.calendar_today),
                  ),
                ),
                const SizedBox(height: 10),
                const SizedBox(height: 10),
                TextField(
                  controller: endradeController,
                  onTap: () async {
                    DateTime? pickedDate = await showDatePicker(
                      context: context,
                      initialDate: DateTime.now(),
                      firstDate: DateTime(2000),
                      lastDate: DateTime(2101),
                    );
                    if (pickedDate != null) {
                      setState(() {
                        endradeController.text =
                            pickedDate.toString(); // Update text field value
                      });
                    }
                  },
                  decoration: const InputDecoration(
                    labelText: 'Select End Date',
                    suffixIcon: Icon(Icons.calendar_today),
                  ),
                ),
                const SizedBox(height: 10),
                ElevatedButton(
                  onPressed: () {
                    _pickImage(ImageSource.gallery);
                  },
                  style: ButtonStyle(
                    backgroundColor:
                        MaterialStateProperty.all<Color>(Colors.green),
                    shape: MaterialStateProperty.all<OutlinedBorder>(
                      RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(20.0),
                      ),
                    ),
                  ),
                  child: const Text(
                    'Select Image',
                    style: TextStyle(fontSize: 20, color: Colors.white),
                  ),
                ),
                const SizedBox(height: 10),
                _pickedImage != null
                    ? Image.file(_pickedImage!)
                    : const SizedBox.shrink(),
                const SizedBox(height: 20),
                ElevatedButton(
                  onPressed: () {
                    if (nameController.text.trim().isEmpty ||
                        startdateController.text.trim().isEmpty ||
                        endradeController.text.trim().isEmpty) {
                      showDialog(
                        context: context,
                        builder: (BuildContext context) {
                          return AlertDialog(
                            title: const Text('Create League'),
                            content: const Text(
                              "Please make sure that no field is empty",
                              style: TextStyle(
                                  fontSize: 20, fontWeight: FontWeight.bold),
                            ),
                            actions: <Widget>[
                              TextButton(
                                onPressed: () {
                                  Navigator.of(context).pop();
                                },
                                child: const Text(
                                  'OK',
                                  style: TextStyle(
                                      fontSize: 20,
                                      fontWeight: FontWeight.bold),
                                ),
                              ),
                            ],
                          );
                        },
                      );
                      return; // Return to avoid further execution if fields are empty
                    }

                    uploadData();
                    Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(
                        builder: (context) => const ViewLeagues(),
                      ),
                    );
                  },
                  style: ButtonStyle(
                    backgroundColor:
                        MaterialStateProperty.all<Color>(Colors.green),
                    shape: MaterialStateProperty.all<OutlinedBorder>(
                      RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(20.0),
                      ),
                    ),
                  ),
                  child: const Text(
                    'Save',
                    style: TextStyle(fontSize: 20, color: Colors.white),
                  ),
                ),
              ],
            ),
          ),
        ));
  }
}
