import 'package:flutter/services.dart';
import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;

import 'dart:convert';
import 'dart:async';

import 'config.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return const MaterialApp(
      home: ViewResults(),
    );
  }
}

//..............................  Loans ......................................

class ViewResults extends StatefulWidget {
  const ViewResults({super.key});

  @override
  _ViewResultsState createState() => _ViewResultsState();
}

class _ViewResultsState extends State<ViewResults> {
  List<Map<String, dynamic>> eggDataList = [];
  String? errorMessage;

  @override
  void initState() {
    super.initState();
    fetchData();
  }

  Future<void> fetchData() async {
    try {
      final response =
          await http.get(Uri.parse('${AppConfig.baseUrl}view_results.php'));

      if (response.statusCode == 200) {
        final dynamic data = json.decode(response.body);

        if (response.body.isEmpty) {
          setState(() {
            eggDataList = [];
            errorMessage = 'No data found'; // Or a more user-friendly message
          });
        }

        if (data is List) {
          setState(() {
            eggDataList = data.cast<Map<String, dynamic>>();
          });
        } else if (data is String && data.toLowerCase() == 'no data found') {
          setState(() {
            eggDataList = [];
          });
        } else {
          throw Exception('Unexpected response format');
        }
      } else {
        throw Exception('Failed to load data: ${response.statusCode}');
      }
    } catch (e) {
      eggDataList = [];
      errorMessage = 'No data found';
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        iconTheme: const IconThemeData(color: Colors.white),
        backgroundColor: Color.fromARGB(255, 16, 99, 60),
        foregroundColor: const Color.fromARGB(255, 252, 252, 252),
        title: const Text(
          'Add Results',
          style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
        ),
      ),
      body: Column(
        children: [
          if (errorMessage != null)
            Padding(
              padding: const EdgeInsets.all(16.0),
              child: Text(
                errorMessage!,
                style: TextStyle(fontSize: 18, color: Colors.red),
              ),
            )
          else if (eggDataList.isEmpty)
            const Padding(
              padding: EdgeInsets.all(16.0),
              child: Text(
                'No data to display',
                style: TextStyle(fontSize: 18),
              ),
            )
          else
            Expanded(
              child: SingleChildScrollView(
                scrollDirection: Axis.vertical,
                child: SingleChildScrollView(
                  scrollDirection: Axis.horizontal,
                  child: DataTableTheme(
                    data: DataTableThemeData(
                      headingRowColor: MaterialStateColor.resolveWith(
                          (states) => const Color.fromARGB(255, 0, 11, 22)!),
                      dataRowColor: MaterialStateColor.resolveWith(
                          (states) => const Color.fromARGB(255, 224, 224, 232)),
                    ),
                    child: DataTable(
                      columns: const [
                        DataColumn(
                          label: Text(
                            ' Date ',
                            style: TextStyle(
                                color: Color.fromARGB(255, 244, 242, 242),
                                fontSize: 17),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            ' Home team',
                            style: TextStyle(
                                color: Color.fromARGB(255, 248, 246, 246),
                                fontSize: 17),
                          ),
                        ),
                        DataColumn(
                          label: Text(
                            'Away Team',
                            style: TextStyle(color: Colors.white, fontSize: 17),
                          ),
                        ),
                      ],
                      rows: eggDataList.map((eggData) {
                        return DataRow(
                          onSelectChanged: (selected) {
                            if (selected!) {
                              // Handle row tap gesture here
                              // Navigate to payment page with loan details
                              Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder: (context) => LoanPaymentPage(
                                    gamedate: '${eggData['mydate']}',
                                    hometeam: '${eggData['home_team_name']}',
                                    awayteam: '${eggData['away_team_name']}',
                                    homeimage: '${eggData['home_team_image']}',
                                    awayimage: '${eggData['away_team_image']}',
                                    fixtureid: '${eggData['fixtureid']}',
                                    resultStatus: '${eggData['result_status']}',
                                  ),
                                ),
                              );
                            }
                          },
                          cells: [
                            DataCell(
                              Text(
                                '${eggData['formatted_date']}',
                                style: const TextStyle(
                                    color: Color.fromARGB(255, 0, 10, 7),
                                    fontWeight: FontWeight.bold,
                                    fontSize: 18),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${eggData['home_team_name']}',
                                style: const TextStyle(
                                    color: Color.fromARGB(255, 0, 10, 7),
                                    fontWeight: FontWeight.bold,
                                    fontSize: 18),
                              ),
                            ),
                            DataCell(
                              Text(
                                '${eggData['away_team_name']}',
                                style: const TextStyle(
                                    color: Color.fromARGB(255, 0, 10, 7),
                                    fontWeight: FontWeight.bold,
                                    fontSize: 18),
                              ),
                            ),
                          ],
                        );
                      }).toList(),
                    ),
                  ),
                ),
              ),
            ),
          const SizedBox(height: 20),
        ],
      ),
    );
  }
}

//..................................................Edit result.....................................

class LoanPaymentPage extends StatefulWidget {
  final String gamedate;
  final String hometeam;
  final String awayteam;
  final String homeimage;
  final String awayimage;
  final String fixtureid;
  final String resultStatus;

  const LoanPaymentPage({
    required this.gamedate,
    required this.hometeam,
    required this.awayteam,
    required this.homeimage,
    required this.awayimage,
    required this.fixtureid,
    required this.resultStatus,
  });

  @override
  _LoanPaymentPageState createState() => _LoanPaymentPageState();
}

class _LoanPaymentPageState extends State<LoanPaymentPage> {
  late TextEditingController hometeamController;
  late TextEditingController awayteamController;

  @override
  void initState() {
    super.initState();
    hometeamController = TextEditingController();
    awayteamController = TextEditingController();
  }

  @override
  void dispose() {
    hometeamController.dispose();
    awayteamController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Color.fromARGB(255, 16, 99, 60),
        foregroundColor: const Color.fromARGB(255, 252, 252, 252),
        title: const Text('Results'),
      ),
      body: SingleChildScrollView(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              'Home team: ${widget.hometeam}',
              style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 20),
            ),
            Container(
              padding: const EdgeInsets.all(20),
              child: const Text(
                'Versus',
                style: TextStyle(fontWeight: FontWeight.bold, fontSize: 20),
              ),
            ),
            Text(
              'Away team: ${widget.awayteam}',
              style: const TextStyle(fontWeight: FontWeight.bold, fontSize: 20),
            ),
            const SizedBox(height: 20),
            TextField(
              controller: hometeamController,
              keyboardType: TextInputType.number,
              inputFormatters: [
                FilteringTextInputFormatter.digitsOnly, // Accepts only digits
              ],
              decoration: const InputDecoration(
                labelText: 'Home Team Result ',
                hintStyle: TextStyle(fontWeight: FontWeight.bold),
              ),
            ),
            const SizedBox(height: 20),
            TextField(
              controller: awayteamController,
              keyboardType: TextInputType.number,
              inputFormatters: [
                FilteringTextInputFormatter.digitsOnly, // Accepts only digits
              ],
              decoration: const InputDecoration(
                labelText: 'Away Team result',
                hintStyle: TextStyle(fontWeight: FontWeight.bold),
              ),
            ),
            const SizedBox(height: 20),
            ElevatedButton(
              onPressed: () async {
                // Access paymentController.text for the payment amount
                String hmoeteamresult = hometeamController.text;
                String awatteamresult = awayteamController.text;
                // Handle payment submission logic

                const String url = '${AppConfig.baseUrl}add_result.php';

                try {
                  final response = await http.post(
                    Uri.parse(url),
                    body: {
                      'home_team_name': widget.hometeam,
                      'away_team_name': widget.awayteam,
                      'date': widget.gamedate,
                      'home_team_image': widget.homeimage,
                      'away_team_image': widget.awayimage,
                      'home_team_goal': hmoeteamresult,
                      'away_team_goal': awatteamresult,
                      'fixture_id': widget.fixtureid,
                      'result_status': widget.resultStatus,
                    },
                  );

                  if (response.statusCode == 200) {
                    // ignore: use_build_context_synchronously
                    print(
                      widget.resultStatus,
                    );
                    Navigator.pop(context);
                    // ignore: use_build_context_synchronously
                    Navigator.pushReplacement(
                      context,
                      MaterialPageRoute(
                        builder: (context) => const ViewResults(),
                      ),
                    );
                  } else {
                    // Handle other response statuses
                    print('Error: ${response.statusCode}');
                    // You might want to show an error message to the user
                  }
                } catch (e) {
                  // Handle network or other errors
                  print('Error: $e');
                  // You might want to show an error message to the user
                }
              },
              style: ButtonStyle(
                backgroundColor: MaterialStateProperty.all<Color>(Colors.green),
                shape: MaterialStateProperty.all<OutlinedBorder>(
                  RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(20.0),
                  ),
                ),
              ),
              child: const Text(
                'Save Result',
                style: TextStyle(fontSize: 20, color: Colors.white),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
